SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       ic.key_ordinal AS ORDINAL_POSITION, c.name AS COLUMN_NAME
FROM   sys.objects AS o
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id
       INNER JOIN sys.indexes AS i
             ON o.object_id = i.object_id
       INNER JOIN sys.index_columns AS ic
             ON i.object_id = ic.object_id
                AND i.index_id = ic.index_id
       INNER JOIN sys.columns AS c
             ON ic.object_id = c.object_id
                AND ic.column_id = c.column_id
WHERE  i.is_primary_key = 1
ORDER  BY TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION;

--> ATTENTION : cette requte base sur les vues systmes peut vous prsenter des tables systmes  la diffrence de la requte base sur les vues normalises.
--              dans ce cas, rajouter la restriction suivante dans la clause WHERE :
--              AND  o."type" IN ('U', 'V')